Ext.data.JsonP.sol_common_as_functions_CreateSignedPdf({"tagname":"class","name":"sol.common.as.functions.CreateSignedPdf","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"lib_sol.common.as.functions.CreateSignedPdf.js","href":"lib_sol.common.as.functions.CreateSignedPdf.html#sol-common-as-functions-CreateSignedPdf"}],"private":true,"author":[{"tagname":"author","name":"MW, ELO Digital Office GmbH","email":null}],"eloas":true,"requires":["sol.common.JsonUtils","sol.common.RepoUtils","sol.common.WfUtils","sol.common.as.FunctionBase"],"aliases":{},"alternateClassNames":[],"extends":"sol.common.as.FunctionBase","mixins":[],"uses":[],"members":[{"name":"dataNodeName","tagname":"cfg","owner":"sol.common.as.functions.CreateSignedPdf","id":"cfg-dataNodeName","meta":{}},{"name":"dstFolderId","tagname":"cfg","owner":"sol.common.as.functions.CreateSignedPdf","id":"cfg-dstFolderId","meta":{}},{"name":"field","tagname":"cfg","owner":"sol.common.as.functions.CreateSignedPdf","id":"cfg-field","meta":{}},{"name":"flowId","tagname":"cfg","owner":"sol.common.as.functions.CreateSignedPdf","id":"cfg-flowId","meta":{"required":true}},{"name":"name","tagname":"cfg","owner":"sol.common.as.functions.CreateSignedPdf","id":"cfg-name","meta":{}},{"name":"objId","tagname":"cfg","owner":"sol.common.as.functions.CreateSignedPdf","id":"cfg-objId","meta":{"required":true}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"signaturType","tagname":"cfg","owner":"sol.common.as.functions.CreateSignedPdf","id":"cfg-signaturType","meta":{}},{"name":"signatureBasePath","tagname":"cfg","owner":"sol.common.as.functions.CreateSignedPdf","id":"cfg-signatureBasePath","meta":{}},{"name":"templateId","tagname":"cfg","owner":"sol.common.as.functions.CreateSignedPdf","id":"cfg-templateId","meta":{}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.common.as.FunctionBase","id":"property-logger","meta":{"protected":true}},{"name":"requiredProperty","tagname":"property","owner":"sol.common.as.functions.CreateSignedPdf","id":"property-requiredProperty","meta":{"private":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"convertOutputStreamToInputStream","tagname":"method","owner":"sol.common.as.functions.CreateSignedPdf","id":"method-convertOutputStreamToInputStream","meta":{"private":true}},{"name":"execute","tagname":"method","owner":"sol.common.as.FunctionBase","id":"method-execute","meta":{}},{"name":"getName","tagname":"method","owner":"sol.common.as.functions.CreateSignedPdf","id":"method-getName","meta":{"private":true}},{"name":"getTemplateId","tagname":"method","owner":"sol.common.as.functions.CreateSignedPdf","id":"method-getTemplateId","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.common.as.FunctionBase","id":"method-initialize","meta":{"private":true}},{"name":"process","tagname":"method","owner":"sol.common.as.functions.CreateSignedPdf","id":"method-process","meta":{"abstract":true}}],"code_type":"ext_define","id":"class-sol.common.as.functions.CreateSignedPdf","short_doc":"Creates a signed PDF file\nCombines a given file with a signature image. ...","classIcon":"icon-class","superclasses":["sol.Base","sol.common.as.FunctionBase"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><a href='#!/api/sol.common.as.FunctionBase' rel='sol.common.as.FunctionBase' class='docClass'>sol.common.as.FunctionBase</a><div class='subclass '><strong>sol.common.as.functions.CreateSignedPdf</strong></div></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.JsonUtils' rel='sol.common.JsonUtils' class='docClass'>sol.common.JsonUtils</a></div><div class='dependency'><a href='#!/api/sol.common.RepoUtils' rel='sol.common.RepoUtils' class='docClass'>sol.common.RepoUtils</a></div><div class='dependency'><a href='#!/api/sol.common.WfUtils' rel='sol.common.WfUtils' class='docClass'>sol.common.WfUtils</a></div><div class='dependency'><a href='#!/api/sol.common.as.FunctionBase' rel='sol.common.as.FunctionBase' class='docClass'>sol.common.as.FunctionBase</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.as.functions.CreateSignedPdf.html#sol-common-as-functions-CreateSignedPdf' target='_blank'>lib_sol.common.as.functions.CreateSignedPdf.js</a></div></pre><div class='doc-contents'><div class='rounded-box private-box'><p><strong>NOTE:</strong> This is a private utility class for internal use by the framework. Don't rely on its existence.</p></div><p>Creates a signed PDF file\nCombines a given file with a signature image.\nThe signature image is retrieved as base64 content from a \"properties\" property of a data node or form a form blob field</p>\n\n<p>Sample node configuration:</p>\n\n<p>   {\n     \"$directRule\": \"sol.common.CreateSignedPdf\" ,\n     \"field\": {\n       \"type\": \"FORMBLOB\",\n       \"key\": \"WO_SIGNATURE\"\n     },\n     \"signatureBasePath\": \"ARCPATH[(E10E1000-E100-E100-E100-E10E10E10E00)]:/Business Solutions/visitor/Configuration/Reports/Signature\",\n     \"signaturType\": \"Default\"\n   }</p>\n\n<p>   {\n     \"$function\": \"<a href=\"#!/api/sol.common.as.functions.CreateSignedPdf\" rel=\"sol.common.as.functions.CreateSignedPdf\" class=\"docClass\">sol.common.as.functions.CreateSignedPdf</a>\" ,\n     \"dataNodeName\": \"[data] signature\",\n     \"templateId\": \"ARCPATH:/Administration/Business Solutions/visitor/Configuration/Reports/Signature/Signature\",\n     \"name\": \"signed\"\n   }</p>\n</div><div class='members'><div class='members-section'><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Required config options</h3><div id='cfg-flowId' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.CreateSignedPdf'>sol.common.as.functions.CreateSignedPdf</span><br/><a href='source/lib_sol.common.as.functions.CreateSignedPdf.html#sol-common-as-functions-CreateSignedPdf-cfg-flowId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.CreateSignedPdf-cfg-flowId' class='name expandable'>flowId</a> : String<span class=\"signature\"><span class='required' >required</span></span></div><div class='description'><div class='short'><p>Workflow ID</p>\n</div><div class='long'><p>Workflow ID</p>\n</div></div></div><div id='cfg-objId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.CreateSignedPdf'>sol.common.as.functions.CreateSignedPdf</span><br/><a href='source/lib_sol.common.as.functions.CreateSignedPdf.html#sol-common-as-functions-CreateSignedPdf-cfg-objId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.CreateSignedPdf-cfg-objId' class='name expandable'>objId</a> : String<span class=\"signature\"><span class='required' >required</span></span></div><div class='description'><div class='short'><p>Object ID of the PDF file that should be signed</p>\n</div><div class='long'><p>Object ID of the PDF file that should be signed</p>\n<p>Overrides: <a href=\"#!/api/sol.common.as.FunctionBase-cfg-objId\" rel=\"sol.common.as.FunctionBase-cfg-objId\" class=\"docClass\">sol.common.as.FunctionBase.objId</a></p></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Optional config options</h3><div id='cfg-dataNodeName' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.CreateSignedPdf'>sol.common.as.functions.CreateSignedPdf</span><br/><a href='source/lib_sol.common.as.functions.CreateSignedPdf.html#sol-common-as-functions-CreateSignedPdf-cfg-dataNodeName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.CreateSignedPdf-cfg-dataNodeName' class='name expandable'>dataNodeName</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Name which holds the base64 string with the signature</p>\n</div><div class='long'><p>Name which holds the base64 string with the signature</p>\n</div></div></div><div id='cfg-dstFolderId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.CreateSignedPdf'>sol.common.as.functions.CreateSignedPdf</span><br/><a href='source/lib_sol.common.as.functions.CreateSignedPdf.html#sol-common-as-functions-CreateSignedPdf-cfg-dstFolderId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.CreateSignedPdf-cfg-dstFolderId' class='name expandable'>dstFolderId</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>(optional)\nFolder ID of the destination folder</p>\n</div><div class='long'><p>(optional)\nFolder ID of the destination folder</p>\n</div></div></div><div id='cfg-field' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.CreateSignedPdf'>sol.common.as.functions.CreateSignedPdf</span><br/><a href='source/lib_sol.common.as.functions.CreateSignedPdf.html#sol-common-as-functions-CreateSignedPdf-cfg-field' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.CreateSignedPdf-cfg-field' class='name expandable'>field</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Field that contains the signature data</p>\n</div><div class='long'><p>Field that contains the signature data</p>\n</div></div></div><div id='cfg-name' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.CreateSignedPdf'>sol.common.as.functions.CreateSignedPdf</span><br/><a href='source/lib_sol.common.as.functions.CreateSignedPdf.html#sol-common-as-functions-CreateSignedPdf-cfg-name' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.CreateSignedPdf-cfg-name' class='name expandable'>name</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>(optional)\nName of the created document, default will be the name of the original element</p>\n</div><div class='long'><p>(optional)\nName of the created document, default will be the name of the original element</p>\n</div></div></div><div id='cfg-requiredConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div><div id='cfg-signaturType' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.CreateSignedPdf'>sol.common.as.functions.CreateSignedPdf</span><br/><a href='source/lib_sol.common.as.functions.CreateSignedPdf.html#sol-common-as-functions-CreateSignedPdf-cfg-signaturType' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.CreateSignedPdf-cfg-signaturType' class='name expandable'>signaturType</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional)\nThe template name for the signature (in the signatureBasePath). ...</div><div class='long'><p>(optional)\nThe template name for the signature (in the <code>signatureBasePath</code>). If not set, <code>templateId</code> has to be defined. If a <code>templateId</code> is defined, it has priority.</p>\n</div></div></div><div id='cfg-signatureBasePath' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.CreateSignedPdf'>sol.common.as.functions.CreateSignedPdf</span><br/><a href='source/lib_sol.common.as.functions.CreateSignedPdf.html#sol-common-as-functions-CreateSignedPdf-cfg-signatureBasePath' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.CreateSignedPdf-cfg-signatureBasePath' class='name expandable'>signatureBasePath</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional)\nARCPATH with the signatur types. ...</div><div class='long'><p>(optional)\nARCPATH with the signatur types. If not set, <code>templateId</code> has to be defined. If a <code>templateId</code> is defined, it has priority.</p>\n</div></div></div><div id='cfg-templateId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.CreateSignedPdf'>sol.common.as.functions.CreateSignedPdf</span><br/><a href='source/lib_sol.common.as.functions.CreateSignedPdf.html#sol-common-as-functions-CreateSignedPdf-cfg-templateId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.CreateSignedPdf-cfg-templateId' class='name expandable'>templateId</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional)\nObject ID of the FOP template. ...</div><div class='long'><p>(optional)\nObject ID of the FOP template. Either this, or <code>signatureBasePath</code> and <code>signaturType</code> has to be set. If a <code>templateId</code> is defined, it has priority.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.as.FunctionBase' rel='sol.common.as.FunctionBase' class='defined-in docClass'>sol.common.as.FunctionBase</a><br/><a href='source/lib_sol.common.as.FunctionBase.html#sol-common-as-FunctionBase-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.FunctionBase-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>The logger for the module</p>\n</div><div class='long'><p>The logger for the module</p>\n<p>Overrides: <a href=\"#!/api/sol.Base-property-logger\" rel=\"sol.Base-property-logger\" class=\"docClass\">sol.Base.logger</a></p></div></div></div><div id='property-requiredProperty' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.CreateSignedPdf'>sol.common.as.functions.CreateSignedPdf</span><br/><a href='source/lib_sol.common.as.functions.CreateSignedPdf.html#sol-common-as-functions-CreateSignedPdf-property-requiredProperty' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.CreateSignedPdf-property-requiredProperty' class='name expandable'>requiredProperty</a> : Array<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>[&quot;objId&quot;, &quot;flowId&quot;, &quot;dataNodeName&quot;]</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-convertOutputStreamToInputStream' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.CreateSignedPdf'>sol.common.as.functions.CreateSignedPdf</span><br/><a href='source/lib_sol.common.as.functions.CreateSignedPdf.html#sol-common-as-functions-CreateSignedPdf-method-convertOutputStreamToInputStream' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.CreateSignedPdf-method-convertOutputStreamToInputStream' class='name expandable'>convertOutputStreamToInputStream</a>( <span class='pre'>outputStream</span> ) : java.io.InputStream<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Converts an output stream to an input stream ...</div><div class='long'><p>Converts an output stream to an input stream</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>outputStream</span> : java.io.OutputStream<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>java.io.InputStream</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-execute' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.as.FunctionBase' rel='sol.common.as.FunctionBase' class='defined-in docClass'>sol.common.as.FunctionBase</a><br/><a href='source/lib_sol.common.as.FunctionBase.html#sol-common-as-FunctionBase-method-execute' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.FunctionBase-method-execute' class='name expandable'>execute</a>( <span class='pre'></span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Execution of the function module ...</div><div class='long'><p>Execution of the function module</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.CreateSignedPdf'>sol.common.as.functions.CreateSignedPdf</span><br/><a href='source/lib_sol.common.as.functions.CreateSignedPdf.html#sol-common-as-functions-CreateSignedPdf-method-getName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.CreateSignedPdf-method-getName' class='name expandable'>getName</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-getTemplateId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.CreateSignedPdf'>sol.common.as.functions.CreateSignedPdf</span><br/><a href='source/lib_sol.common.as.functions.CreateSignedPdf.html#sol-common-as-functions-CreateSignedPdf-method-getTemplateId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.CreateSignedPdf-method-getTemplateId' class='name expandable'>getTemplateId</a>( <span class='pre'></span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.as.FunctionBase' rel='sol.common.as.FunctionBase' class='defined-in docClass'>sol.common.as.FunctionBase</a><br/><a href='source/lib_sol.common.as.FunctionBase.html#sol-common-as-FunctionBase-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.FunctionBase-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a></p></div></div></div><div id='method-process' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.functions.CreateSignedPdf'>sol.common.as.functions.CreateSignedPdf</span><br/><a href='source/lib_sol.common.as.functions.CreateSignedPdf.html#sol-common-as-functions-CreateSignedPdf-method-process' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.functions.CreateSignedPdf-method-process' class='name expandable'>process</a>( <span class='pre'></span> )<span class=\"signature\"><span class='abstract' >abstract</span></span></div><div class='description'><div class='short'>Implementation of function modules' process. ...</div><div class='long'><p>Implementation of function modules' process.\nThis function must be implemented by the child class and should contain the logic of the function module.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.as.FunctionBase-method-process\" rel=\"sol.common.as.FunctionBase-method-process\" class=\"docClass\">sol.common.as.FunctionBase.process</a></p></div></div></div></div></div></div></div>","meta":{"eloas":true,"private":true}});